require( "scripts/style.lua" );


TitleFont = {
  standardFont,
  40,
  BorderColor
};

DescripFont = {
  standardFont,
  20,
  BorderColor
};

LongDescripFont = {
  standardFont,
  20,
  BorderColor
};

titleString = CareerChoiceTitle();



careerButtonGraphics = {
	"buttons/career_choice_a",
	"buttons/career_choice_b",
	"buttons/career_choice_c"
};


function Choice( num )
	descripString = CareerItemDescrip(num);
	iconFile = CareerItemIcon(num);
	longDescrtipString = CareerItemLongDescrip(num);
	return Group {
		CareerChoiceButton
		{
            x = 110 + (150 * num),
            y = 125,
			name="choicebutton_"..num,
			label='',
			graphics=careerButtonGraphics,
			type = kRadio,
			longdescrip=longDescrtipString,
			command=
					function()
						SetCurrentUIChoice(num);
						EnableWindow("continue", true);
					end,
			
			Bitmap
			{
				x = 7,
				y = 6,
				image = iconFile,
			};

		},
		
		Text
		{
			font=DescripFont,
			x= 110 + (150 * num),
			y = 265,
			w = 133,
			h = 200,
			flags = kVAlignTop + kHAlignCenter,
			label = descripString
		},
		
		
		SetStyle(DefaultStyle),
	}
end


MakeDialog
{
		
	Bitmap
	{
		name="careerchoicesbg",
		image="backgrounds/upgrade_dialog",
		x=kCenter,
		y=kCenter,

		
		
		Text
		{
			font=TitleFont,
			x= 0,
			y = 32,
			w = kMax,
			h = 80,
			flags = kVAlignTop + kHAlignCenter,
			label = titleString
		};
		
		BeginGroup();
		Choice(0);
		Choice(1);
		Choice(2);
		
		Text
		{
			name='longdescrip',
			font=LongDescripFont,
			x= 0,
			y = 350,
			w = kMax,
			h = 200,
			flags = kVAlignTop + kHAlignCenter,
			label = ''
		};
			
			
		SetStyle(StandardButtonStyle);
		Button
		{
			x=kCenter,
			y=-110,
			name="continue",
			label="continue",
			command=
					function()
						ActivateCurrentChoice();
						SlideOffWindow("careerchoicesbg");
					end
		},
		SetStyle(DefaultStyle);
		
	},
	
}

EnableWindow("continue", false);
EnableWindow("longdescrip", false);